﻿var extendedrules = {
    context: $(".v-callbacks-extendedrules"),
    datatable: null,
    resultCodes: null,
    interviewers: null,
    initializeDataTable: function () {
        this.datatable = $(".h-extendedrules-table", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getProjectAction("GetExtendedRules", "CallBacks"),
            columns: [
                { "Title": "#", "Name": "Number", "Data": "Number" },
                { "Title": resources.Callback, "Name": "Callback", "Data": "CallbackLabel", "Type": "boolean", "Editable": true },
                { "Title": resources.Result, "Data": "NewResultDescription", "Type": "multiple", "Editable": { "AvailableValues": function () { return extendedrules.getResultCodes(); }, "MaxItems": 1, "LabelField": "Name", "ValueField": "Id" } },
                { "Title": resources.CaseResult, "Data": "LifeState", "Editable": true },
                { "Title": resources.ResultSequence, "Name": "ResultsSequence", "Editable": true },
                { "Title": resources.Interviewer, "Data": "InterviewerDescription", "Type": "multiple", "Editable": { "AvailableValues": function () { return extendedrules.getInterviewers(); }, "MaxItems": 1, "LabelField": "Name", "ValueField": "Id" } },
                { "Title": resources.Delay, "Data": "Delay", "Type": "numeric", "Editable": true },
                { "Title": resources.Unit, "Data": "UnitEnum", "Name": "Unit", "Type": "enum", "EnumType": "RulUnits", "Editable": true },
                { "Title": resources.PriorityAction, "Data": "PriorityTypeEnum", "Name": "PriorityType", "Type": "enum", "EnumType": "RulPriorityTypes", "Editable": true },
                { "Title": resources.Priority, "Data": "Priority", "Type": "numeric", "Editable": true },
                { "Title": resources.DialingMode, "Data": "DialingModeEnum", "Name": "DialingMode", "Type": "enum", "EnumType": "DialingModes", "Editable": true },
                { "Title": resources.Counter, "Name": "WaveInc", "Data": "WaveIncLabel", "Type": "boolean", "Editable": true },
                { "Title": resources.SynchResult, "Data": "SynchResultEnum", "Name": "SynchResult", "Type": "enum", "EnumType": "SynchResults", "Editable": true, "Visible": projectMenu.project.EnableCAPI, "HideInSelector": !projectMenu.project.EnableCAPI },
                { "Title": resources.LiftStratumRestriction, "Name": "RestrictionOverride", "Data": "RestrictionOverrideLabel", "Type": "boolean", "Editable": true },
                { "Title": resources.UploadToA4S, "Name": "UploadToA4S", "Data": "UploadToA4SLabel", "Type": "boolean", "Editable": true, "Visible": projectMenu.project.EnableA4S, "HideInSelector": !projectMenu.project.EnableA4S },
                { "Title": resources.PhoneCyclingBehavior, "Data": "PhoneCyclingBehaviorEnum", "Name": "PhoneCyclingBehavior", "Type": "enum", "EnumType": "PhoneCyclingBehaviorType", "Editable": true }
            ],
            localizableTexts: { "Search": resources.SearchExtendedRules },
            stateKey: "CallbackExtendedRules",
            multiEdit: true,
            rowUpdated: function (event, data) {
                if (data.value === "")
                    data.flagError(true);
                else if (data.fieldName == "ResultsSequence" && !extendedrules.validateResultSequence(data.value))
                    data.flagError(true);
            },
            rowsUpdated: function (event, data) {

                data.rows.forEach(function (row, index) { row["NewResultDescription"] = ""; });

                a4.callServerMethod(a4.getProjectAction("UpdateExtendedRules", "CallBacks"), { extendedRules: data.rows }, function () { data.multiEditSaveCallback(); });
            },
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "moveup", "Label": resources.MoveUp},
                { "Action": "movedown", "Label": resources.MoveDown },
                { "Divider": true },
                { "Action": "insertbefore", "Label": resources.InsertBefore },
                { "Action": "insertafter", "Label": resources.InsertAfter },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        extendedrules.deleteExtendedRules([row.Id]);
                        break;
                    case "properties":
                        extendedrules.editExtendedRules(row.Id);
                        break;
                    case "moveup":
                        if (data.index !== 0) {
                            a4.callServerMethod(a4.getProjectAction("MoveExtendedRules", "CallBacks"), { extendedRuleId: row.Id, position: row.Number - 1 }, function (result) {
                                extendedrules.refreshContent();
                            });
                        }
                        break;
                    case "movedown":
                        if (data.index !== extendedrules.datatable.find('.dataTables_scrollBody .dataTable tbody tr').length-1) {
                            a4.callServerMethod(a4.getProjectAction("MoveExtendedRules", "CallBacks"), { extendedRuleId: row.Id, position: row.Number + 1 }, function (result) {
                                extendedrules.refreshContent();
                            });
                        }
                        break;
                    case "insertbefore":
                        modalDialog.showWindow(a4.getProjectAction("EditExtendedRule", "CallBacks", { position: row.Number }), 650, 700, { afterClose: function () { extendedrules.refreshContent(); } });
                        break;
                    case "insertafter":
                        modalDialog.showWindow(a4.getProjectAction("EditExtendedRule", "CallBacks", { position: row.Number+1 }), 650, 700, { afterClose: function () { extendedrules.refreshContent(); } });
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    extendedrules.deleteExtendedRules(ids);
                }
            },
            toggleMultiEdit: function (evt, data) {
                if (extendedrules.resultCodes == null) {
                    a4.callServerMethod(a4.getProjectAction("GetResultCodesForAutoComplete", "CallBacks"), {}, function (result) {
                        extendedrules.resultCodes = result;
                    });
                }

                if (extendedrules.interviewers == null) {
                    a4.callServerMethod(a4.getProjectAction("GetInterviewersForAutoComplete", "CallBacks"), { isCallback: true }, function (result) {
                        extendedrules.interviewers = result;
                    });
                }
            }
        });
    },
    bindEvents: function () {      
        extendedrules.context.on("click", ".h-add-extendedrules", function () {
            modalDialog.showWindow(a4.getProjectAction("EditExtendedRule", "CallBacks"), 650, 750, { afterClose: function () { extendedrules.refreshContent(); } });
        });

        extendedrules.context.on("click", ".h-exportextendedRules", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getProjectAction("ExportExtendedRules", "CallBacks"), { columns: extendedrules.datatable.a4datatable("getVisibleColumns").join() }, function (result) {
                a4.hideBusyBox();
                window.location = a4.getProjectAction("GetExtendedRulesFile", "CallBacks", { filePath: result, fileName: "ExtendedRule.xlsx" });
            });
        });

        extendedrules.context.on("click", ".h-copyextendedRules", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopyExtendedRules", "CallBacks"), { sourceProjectId: sourceProjectId },
                function (result) {
                    extendedrules.refreshContent();
                });
            }, resources.CopyCallbackExtendedRulesFrom, false, confirmCopyExtendedRulesResources);
        });

        extendedrules.context.on("click", ".h-settings", function () {
            modalDialog.showWindow(a4.getProjectAction("RuleSettings", "CallBacks"), 350, 600, { afterClose: function () { extendedrules.refreshContent(); } });
        });
    },
    deleteExtendedRules: function (extendedruleIds) {
        modalDialog.showConfirmDelete(confirmDeleteExtendedRulesResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteExtendedRules", "CallBacks"), { extendedRuleIds: extendedruleIds }, function (result) {
                extendedrules.refreshContent();
            });
        }, extendedruleIds.length);
    },
    editExtendedRules: function (extendedruleId) {
        modalDialog.showWindow(a4.getProjectAction("EditExtendedRule", "CallBacks", { extendedRuleId: extendedruleId }), 650, 700, { afterClose: function () { extendedrules.refreshContent(); } });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    getResultCodes: function () {
        return extendedrules.resultCodes;
    },
    getInterviewers: function () {
        return extendedrules.interviewers;
    },
    validateResultSequence: function (sequence) {
        var codes = _.uniq(_.compact(sequence.split(/[\[\]\*\s]/)));

        return _.every(codes, function (code) {
            return _.some(extendedrules.resultCodes, function (resultCode) {
                return code.toUpperCase() == resultCode.Id.toUpperCase();
            });
        });
    }
}

$(document).ready(function () {
    if (extendedrules.context.length > 0) {
        $(projectMenu).ready(function () {
            extendedrules.initializeDataTable();
            extendedrules.bindEvents();
        });
    }
});